---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 11
  claims_without_evidence: 3
confidence_derived: 0.79
---

# 根拠レポート：9-systat - リアルタイムシステム統計ダッシュボード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.79**
  - 根拠あり：11 / 14、根拠なし：3
- 優先レビュー（高）
  1. **表示モードの完全な一覧**：systat.hのcmdtab定義を未読
  2. **メインイベントループの詳細**：main.cの150行以降を限定的にしか読んでいない
  3. **各表示モード固有のレイアウト詳細**：個別モードファイルを未読

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.bin/systat/main.c` 1-150行目（先頭150行）
- E-02: `usr.bin/systat/main.c` 53-67行目（グローバル変数）
- E-03: `usr.bin/systat/main.c` 78-123行目（parse_cmd_args関数）
- E-04: `usr.bin/systat/main.c` 125-137行目（resize関数）
- E-05: `usr.bin/systat/main.c` 140-150行目（main関数冒頭）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | curses全画面表示のリアルタイムダッシュボード | E-02 (65行目: WINDOW *wnd), E-04 (129行目: endwin, 130行目: refresh) | ○ |
| C-02 | デフォルト更新間隔5秒 | E-02 (58行目: delay = 5000000) | ○ |
| C-03 | SLIST_HEAD(&commands)でモードリスト管理 | E-01 (71-76行目) | ○ |
| C-04 | parse_cmd_argsでハイフン付き引数をモード名として解析 | E-03 (86-98行目) | ○ |
| C-05 | SIGWINCH時にresize関数でリサイズ処理 | E-04 (125-137行目) | ○ |
| C-06 | resize関数でendwin→refresh→clear→labels→display→status | E-04 (129-136行目) | ○ |
| C-07 | kvm_openfiles使用（use_kvm=1デフォルト） | E-02 (67行目: use_kvm = 1) | ○ |
| C-08 | setlocale(LC_ALL, "")でロケール設定 | E-05 (148行目) | ○ |
| C-09 | hertz値はkern.clockrate sysctlから取得 | E-02 (60行目: clkinfo), E-02 (61行目: hertz) | ○ |
| C-10 | CMDLINE = LINES - 1 でコマンドライン位置 | E-04 (133行目) | ○ |
| C-11 | 更新間隔の小数点指定対応 | E-03 (104行目: strtod * 1000000.0) | ○ |
| C-12 | 表示モードの完全な一覧（9種類以上） | **根拠なし**（systat.h/mode.c未読） | △ |
| C-13 | メインイベントループの詳細 | **根拠なし**（main.c 150行以降未読） | △ |
| C-14 | 各表示モード固有のレイアウト詳細 | **根拠なし**（個別モードファイル未読） | △ |

## 4) 不足情報（Unknown / Missing）
- systat.hのcmdtab構造体定義と登録された表示モード一覧
  - 候補：`usr.bin/systat/systat.h`
- main.cの完全なメインループ実装
  - 候補：`usr.bin/systat/main.c` 150行目以降
- 各表示モードの固有レイアウト
  - 候補：`usr.bin/systat/vmstat.c` / `usr.bin/systat/tcp.c` / `usr.bin/systat/iostat.c` 等

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - main.cの先頭150行のみ読了のため、メインループの動作詳細と表示モード一覧が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] systat.hのcmdtab構造体と登録モード一覧を確認
- [ ] main.cのメインループ全体を確認
- [ ] 各表示モード（vmstat.c, tcp.c等）のlabels/display関数を確認
- [ ] モード切替のインタラクティブコマンド一覧を確認
